# Description
_Please include a text summary of the change and which issue(s) is/are fixed or addressed. Should the change have any dependencies 
then these should be listed here._

Fixes # (issue)
_In order to make tracking easier and to properly document the process,
pull requests should always refer to an active issue in the list - be it a bug fix or an enhancement or some other type of issue._

## Type of change

_Please delete options that are not relevant._

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] This change requires a documentation update

# How Has This Been Tested?

_Please describe the tests that you ran to verify your changes. Provide instructions so we can reproduce. Please also list any relevant details for your test configuration_

- [ ] Test A
- [ ] Test B

**Test Configuration**:
* Arduino version:
* Arduino Hardware:
* SDK: (Arduino IDE, Atmel Studio, Visual Studio, Visual Micro, etc.)
* Development system: (Windows, Web, Linux, etc.)

# Checklist:

- [ ] The changes made link back to an existing issue number
- [ ] I have performed a self-review of my own code
- [ ] My code follows the style guidelines of this project
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] The code adheres to the [Google Style Guide](https://google.github.io/styleguide/cppguide.html)
- [ ] The code follows the existing program documentation style using [doxygen](http://www.doxygen.nl/)
- [ ] I have made corresponding changes to the documentation / Wiki Page(s)
- [ ] My changes generate no new warnings
- [ ] The automated TRAVIS-CI run has a status of "passed"
- [ ] I have checked potential areas where regression errors could occur and have found no issues
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes

[![Zanshin Logo](https://zanduino.github.io/Images/zanshinkanjitiny.gif) <img src="https://zanduino.github.io/Images/zanshintext.gif" width="75"/>](https://zanduino.github.io)
