import json
from subprocess import Popen, PIPE
import subprocess
from pyduinocli.errors.arduinoerror import ArduinoError
from pyduinocli.constants import messages

class CommandBase:
    __ERROR_MESSAGE = "Message"
    __ERROR_CAUSE = "Cause"

    def __init__(self, base_args):
        self._base_args = list(base_args)

    @staticmethod
    def _strip_arg(arg):
        return arg.lstrip("-")

    @staticmethod
    def _strip_args(args):
        out = list()
        for arg in args:
            out.append(CommandBase._strip_arg(arg))
        return out

    @staticmethod
    def __parse_output(data):
        try:
            return json.loads(data)
        except ValueError:
            return data

    def _exec(self, args):
        
        command = list(self._base_args)
        command.extend(args)
        stdout='?'
        stderr='?'

        try:
            p=subprocess.Popen(command, stdout=PIPE, stderr=PIPE, shell=False)            
            stdout, stderr = p.communicate()
            stdout = stdout.decode("utf-8").strip()
            stderr = stderr.decode("utf-8").strip()

            #return code!=0 -> ERROR
            if p.returncode != 0:
                print(repr(stdout))
                print(repr(stderr))
                
                #parse as JSON                                          
                decoded_out=self.__parse_output(stdout)
                decoded_err=self.__parse_output(stderr)
                
                if type(decoded_out) is dict:
                    return decoded_out
                elif type(decoded_err) is dict:
                    return decoded_err
                else:
                    return stdout+"\n"+stderr

            #parse stdout as JSON          
            decoded_out = self.__parse_output(stdout)

            #default (no error / error without known format)  
            return decoded_out
        
        #except OSError:
        except Exception as e:
            print("EX: "+repr(e))
            return "Exception-base:\n"+repr(stdout)+"\n"+repr(stderr)

